//
//  colortransform.metal
//  EffectMgrMetal
//
//  Created by WS on 2021/5/26.
//  Copyright © 2021 WS. All rights reserved.
//

#include <metal_stdlib>
using namespace metal;
#define RANGE_FULL      0x00000001
#define RANGE_LIMITED   0x00000002
#define SPACE_709       0x00000001
#define SPACE_601       0x00000002

kernel void NV12toBGRA(texture2d<float, access::read> inY [[texture(0)]],
                       texture2d<float, access::read> inUV [[texture(1)]],
                       texture2d<float, access::write> out [[texture(2)]],
                       constant int* range [[buffer(1)]],
                       constant int* space [[buffer(2)]],
                       uint2 gid [[thread_position_in_grid]])
{
    float4 YColor = inY.read(gid) * 255.0f;
    float4 UVColor = inUV.read(gid / 2) * 255.0f;
    float3 rgb = 0.0f;
    if (*space == SPACE_709)
    {
        if (*range == RANGE_LIMITED)
        {
            rgb.x = 1.1644f * (YColor.x - 16.0f) + 1.7927f * (UVColor.y - 128.0f);
            rgb.y = 1.1644f * (YColor.x - 16.0f) - 0.5329f * (UVColor.y - 128.0f) - 0.2132f * (UVColor.x - 128.0f);
            rgb.z = 1.1644f * (YColor.x - 16.0f) + 2.1123f * (UVColor.x - 128.0f);
        }
        else
        {
            rgb.x = YColor.x + 1.5748f * (UVColor.y - 128.0f);
            rgb.y = YColor.x - 0.4681f * (UVColor.y - 128.0f) - 0.1873f * (UVColor.x - 128.0f);
            rgb.z = YColor.x + 1.8556f * (UVColor.x - 128.0f);
        }
    }
    else
    {
        if (*range == RANGE_LIMITED)
        {
            rgb.x = 1.1644f * (YColor.x - 16.0f) + 1.5960f * (UVColor.y - 128.0f);
            rgb.y = 1.1644f * (YColor.x - 16.0f) - 0.8129f * (UVColor.y - 128.0f)- 0.3917f * (UVColor.x - 128.0f);
            rgb.z = 1.1644f * (YColor.x - 16.0f) + 2.0172f * (UVColor.x - 128.0f);
        }
        else
        {
            rgb.x = YColor.x + 1.4020f * (UVColor.y - 128.0f);
            rgb.y = YColor.x - 0.7141f * (UVColor.y - 128.0f) - 0.3441f * (UVColor.x - 128.0f);
            rgb.z = YColor.x + 1.7720f * (UVColor.x - 128.0f);
        }
    }
    out.write(float4(rgb/255.0f, 1.0f), gid);
}

constexpr sampler s(address::clamp_to_zero,
                    filter::linear,
                    compare_func::less);

kernel void BGRAtoNV12(texture2d<float, access::sample> in [[texture(0)]],
                       texture2d<float, access::write> outY [[texture(1)]],
                       texture2d<float, access::write> outUV [[texture(2)]],
                       constant int* width [[buffer(0)]],
                       constant int* height [[buffer(1)]],
                       constant int* space [[buffer(2)]],
                       uint2 gid [[thread_position_in_grid]])
{
    if (*space == SPACE_709)
    {
        float4 YColor = 0.0f;
        float4 UVColor = 0.0f;
        float4 rgb = in.read(gid) * 255.0f;
        
        YColor.x = 0.1825f*rgb.x + 0.6142f*rgb.y + 0.0620f*rgb.z + 16.0f;
        float2 gidUV = float2(gid.x * 1.0f / in.get_width(), gid.y * 1.0f / in.get_height());
        rgb = in.sample(s, gidUV) * 255.0f;
        UVColor.r = -0.1006f*rgb.x - 0.3385f*rgb.y + 0.4392f*rgb.z + 128.0f;
        UVColor.g = 0.4392f*rgb.x - 0.3989f*rgb.y - 0.0402f*rgb.z + 128.0f;
        
        outY.write(YColor / 255.0f, gid);
        outUV.write(UVColor / 255.0f, gid / 2);
        
    }
    else
    {
        float4 YColor = 0.0f;
        float4 UVColor = 0.0f;
        float4 rgb = in.read(gid) * 255.0f;
        YColor.x =  0.257f * rgb.x + 0.504f * rgb.y + 0.098f * rgb.z + 16.0f;;

        float2 gidUV = float2(gid.x * 1.0f / *width, gid.y * 1.0f / *height);
        rgb = in.sample(s, gidUV) * 255.0f;
        UVColor.x = -0.148f * rgb.x - 0.291f * rgb.y + 0.439f * rgb.z + 128.0f;
        UVColor.y = 0.439f * rgb.x - 0.368f * rgb.y - 0.071f * rgb.z + 128.0f;

        outY.write(YColor / 255.0f, gid);
        outUV.write(UVColor / 255.0f, gid / 2);

    }
}
